import java.lang.*;
import java.util.*;

public class FiniteStates 
{	
	Vector MachineVector = new Vector();
	int currentIndex = 0;
	String stringRepresentation;
	int currentState = 0;

	public FiniteStates(String thisFiniteMachine) 
	{
		stringRepresentation = thisFiniteMachine;
		for (int i = 0; i < stringRepresentation.length(); i+=5)
		{
			createMachineObject(new Integer(stringRepresentation.substring(i,i+1)),new Integer(stringRepresentation.substring(i+1,i+2)).intValue(),new Integer(stringRepresentation.substring(i+2,i+3)).intValue(),new Integer(stringRepresentation.substring(i+3,i+4)).intValue(),new Integer(stringRepresentation.substring(i+4,i+5)).intValue());
		}
	}
   	
	public static void main(String[] args)
	{
		String theString;
		
		boolean goodValues = true;
		
		if (args.length > 0)
		{
			theString = args[0];
		}
		else
		{
			Random theRanGen = new Random();
			StringBuffer theRanString = new StringBuffer();

			// 10 Machines
			for (int i = 0; i < 10; i++)
			{
				// Object
				theRanString.append(theRanGen.nextInt(10));
				
				// State One Next Object Index
				theRanString.append(theRanGen.nextInt(10));
				// State One Next Object State
				theRanString.append(theRanGen.nextInt(2));
				
				// State Two Next Object Index
				theRanString.append(theRanGen.nextInt(10));
				// State Two Next Object State
				theRanString.append(theRanGen.nextInt(2));				
			}
			theString = theRanString.toString();				
		}
		
		if (theString.length() % 5 == 0)
		{
			int totalMachines = theString.length()/5;
			for (int i = 0; i < totalMachines; i++)
			{
				String subString = theString.substring(i*5,i*5+5);
				if (new Integer(subString.substring(1,2)).intValue() > totalMachines - 1)
				{
					goodValues = false;
				}
				else if (new Integer(subString.substring(3,4)).intValue() > totalMachines - 1)
				{
					goodValues = false;
				}
			}

		}
		else
		{
			goodValues = false;
		}
		
		if (goodValues)	
		{
			FiniteStates theFiniteStates = new FiniteStates(theString);
			System.out.println(theFiniteStates.playMachine(0,0));
		}
		else
		{
			System.out.println("Not an appropriate string.  Please try again.");
		}
	}

	public String toString()
	{
		return stringRepresentation;
	}

	public String playMachine(int startingIndex, int startingState)
	{
		StringBuffer playedString = new StringBuffer();
		boolean keepGoing = true;
		currentIndex = startingIndex;
		currentState = startingState;
		Integer firstObject = (Integer) ((MachineObject) MachineVector.elementAt(currentIndex)).returnObject();
		playedString.append(firstObject.toString());
		
		int counter = 0;
		while (keepGoing)
		{
			Integer newObject = returnNextObject();
			playedString.append(newObject.toString());

			counter++;			
			if (counter >= 20)
			{
				keepGoing = false;
			}
		}
		
		return playedString.toString();
	}
	
	public Integer returnNextObject()
	{
		currentState = ((Integer) ((MachineObject) MachineVector.elementAt(currentIndex)).returnNextObjectState(currentState)).intValue();
		currentIndex = ((Integer) ((MachineObject) MachineVector.elementAt(currentIndex)).returnNextObjectIndex(currentState)).intValue();
		Integer newObject = (Integer) ((MachineObject) MachineVector.elementAt(currentIndex)).returnObject();
		return newObject;
	}
	
   	public void createMachineObject(Object thisObject, int stateOneNextObjectIndex, int stateOneNextObjectState, int stateTwoNextObjectIndex, int stateTwoNextObjectState)
   	{
		MachineObject currentObject = new MachineObject(thisObject, currentIndex, stateOneNextObjectIndex, stateOneNextObjectState, stateTwoNextObjectIndex, stateTwoNextObjectState);
		MachineVector.add(currentObject);
   	}
   					
	private class MachineObject
	{
		private int stateOneNextObjectIndex;
		private int stateTwoNextObjectIndex;
		private int stateOneNextObjectState;
		private int stateTwoNextObjectState;
		private int thisObjectIndex;
		
		private Object thisObject;
		
		MachineObject(Object thisObject, int thisObjectIndex, int stateOneNextObjectIndex, int stateOneNextObjectState, int stateTwoNextObjectIndex, int stateTwoNextObjectState)		
		{
			this.thisObject = thisObject;
			setThisIndex(thisObjectIndex);
			setNextObjectIndex(stateOneNextObjectIndex, stateOneNextObjectState,1);
			setNextObjectIndex(stateTwoNextObjectIndex, stateTwoNextObjectState,2);
			
			/*
				System.out.println("State One Next Object Index: " + stateOneNextObjectIndex);
				System.out.println("State Two Next Object Index: " + stateTwoNextObjectIndex);
				System.out.println("State One Next Object State: " + stateOneNextObjectState);
				System.out.println("State Two Next Object State: " + stateTwoNextObjectState);
				System.out.println("This Object Index: " + thisObjectIndex);			
			*/
		}
		
		MachineObject(Object thisObject)
		{
			this.thisObject = thisObject;
		}

		Object returnObject()
		{
			return thisObject;
		}

		Integer returnNextObjectIndex(int currentState)
		{
			Integer returnInteger;
			
			if (currentState % 2 == 0)
			{
				returnInteger = new Integer(stateTwoNextObjectIndex);
			}
			else 
			//if (currentState % 2 == 1)
			{
				returnInteger = new Integer(stateOneNextObjectIndex);
			}
			
			return returnInteger;
		}
		
		Integer returnNextObjectState(int currentState)
		{
			Integer returnInteger;
			
			if (currentState % 2 == 0)
			{
				returnInteger = new Integer(stateTwoNextObjectState);
			}
			else 
			//if (currentState % 2 == 1)
			{
				returnInteger = new Integer(stateOneNextObjectState);
			}
			
			return returnInteger;
		}
						
		void setThisIndex(int thisObjectIndex)
		{
			this.thisObjectIndex = thisObjectIndex;
		}
		
		void setNextObjectIndex(int stateNextObjectIndex, int nextObjectState, int stateNumber)
		{
			
			if (stateNumber % 2 == 0)
			{
				stateTwoNextObjectIndex = stateNextObjectIndex;
				stateTwoNextObjectState = nextObjectState;
			}
			else
			{	
				stateOneNextObjectIndex = stateNextObjectIndex;
				stateOneNextObjectState = nextObjectState;
			}
			
		}		
	}
							
}